//--------------------------------------------
//
// LTrim and RTrim (VB style)
// requires MMBasic for MX170 V5.02 or later
// Syntax for CFunction header:
//   ltrim(STRING) STRING
//   rtrim(STRING) STRING
// 
// eg a$=ltrim("   Hello World")
//    PRINT a$ ----> "Hello World"
//--------------------------------------------
// For the TBS-Forum 13.07.2017
//--------------------------------------------

#define _SUPPRESS_PLIB_WARNING
#include <plib.h>
#include "cfunctions.h"

//
// strip leading whitespace from a string
//
char *ltrim(char *string){   
   unsigned char len = (unsigned char) string[0];
   unsigned char i   = 0, tr_len;
   char *s           = GetTempMemory(len+1);

   s[0]              = 0; // for empty string

   if (len > 0) {
        //find first occurrence of non whitespace char from the left
        while(++i <= len && *++string == 32);
       
        i--; // number of spaces
        //remaining string length = len - i
        tr_len = len-i;
        //copy remaining string to s[]        
        for(i = 1; i <= tr_len; i++) s[i] = *string++;

        s[0] = tr_len;// store BASIC (trimmed) string length
   }
   return s;
}

//
// strip trailing whitespace from a string
//
char *rtrim(char *string){  
   char *tr_string   = string; // copy pointer
   unsigned char len = (unsigned char) string[0];
   unsigned char i   = 0, tr_len;
   char *s           = GetTempMemory(len+1);
   
   s[0]              = 0; // for empty string
   
   //if we have an empty string, nothing to do
   if (len != 0) {
       //find first occurrence of non whitespace char from the right
       while(++i <= len && *(--string+len+1) == 32);

       i--; // number of spaces
       //remaining string length = len - i
       tr_len = len-i;
       //copy remaining string to s[]
       for(i = 1; i <= tr_len; i++) s[i] = *++tr_string;       

       s[0] = tr_len;// store BASIC (trimmed) string length
   }
return s;
}

void main(){}